<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Cron;

use Psr\Log\LoggerInterface;
use WriteTextAI\WriteTextAI\Model\FullAutomationCronManager;
use WriteTextAI\WriteTextAI\Cron\BaseCron;
use Magento\User\Model\UserFactory;
use WriteTextAI\WriteTextAI\Model\Api\Session as ApiSession;
use Magento\Framework\App\Config\ScopeConfigInterface;

/**
 * Full Automation Cron Job
 */
class FullAutomation extends BaseCron
{
    /**
     * @var LoggerInterface
     */
    protected LoggerInterface $logger;

    /**
     * @var FullAutomationCronManager
     */
    protected FullAutomationCronManager $fullAutomationCronManager;

    /**
     * Constructor
     *
     * @param LoggerInterface $logger
     * @param FullAutomationCronManager $fullAutomationCronManager
     * @param UserFactory $userFactory
     * @param ApiSession $apiSession
     * @param ScopeConfigInterface $scopeConfig
     */
    public function __construct(
        LoggerInterface $logger,
        FullAutomationCronManager $fullAutomationCronManager,
        UserFactory $userFactory,
        ApiSession $apiSession,
        ScopeConfigInterface $scopeConfig
    ) {
        $this->logger = $logger;
        $this->fullAutomationCronManager = $fullAutomationCronManager;
        parent::__construct($userFactory, $apiSession, $scopeConfig);
    }

    /**
     * Execute full automation process
     *
     * @return void
     */
    public function execute(): void
    {
        try {
            $processedRecords = $this->fullAutomationCronManager->processFullAutomation('Product');
            $processedCategoryRecords = $this->fullAutomationCronManager->processFullAutomation('Category');
            $this->fullAutomationCronManager->reportTransferResults();
        } catch (\Exception $e) {
            //do nothing
            return;
        }
    }
}
