<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Controller\Adminhtml\Setup;

use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Message\ManagerInterface;
use WriteTextAI\WriteTextAI\Helper\Data;
use WriteTextAI\WriteTextAI\Helper\Statistics;
use Magento\Framework\Controller\ResultInterface;
use WriteTextAI\WriteTextAI\Model\UserWebTokenManager;

class Callback extends \Magento\Backend\App\Action
{
    public const METHOD_GET = 'GET';

    public const METHOD_POST = 'POST';

    /**
     * @var ResultFactory
     */
    protected $resultFactory;

    /**
     * @var ManagerInterface
     */
    protected $messageManager;

    /**
     * @var Data
     */
    protected $helper;

    /**
     * @var Statistics
     */
    protected $statisticsHelper;

    /**
     * @var UserWebTokenManager
     */
    protected $userWebTokenManager;

    /**
     * Constructor
     *
     * @param Context $context
     * @param ManagerInterface $messageManager
     * @param Data $helper
     * @param UserWebTokenManager $userWebTokenManager
     * @param Statistics $statisticsHelper
     */
    public function __construct(
        Context $context,
        ManagerInterface $messageManager,
        Data $helper,
        UserWebTokenManager $userWebTokenManager,
        Statistics $statisticsHelper
    ) {
        $this->messageManager = $messageManager;
        $this->helper = $helper;
        $this->userWebTokenManager = $userWebTokenManager;
        $this->statisticsHelper = $statisticsHelper;
        parent::__construct($context);
    }

    /**
     * Callback action
     *
     * @return ResultInterface
     */
    public function execute()
    {
        try {
            $method = $this->getRequest()->getMethod();
            
            if ($method == self::METHOD_GET) {
                $token = $this->getRequest()->getParam('token');
                $region = $this->getRequest()->getParam('region');
            } elseif ($method == self::METHOD_POST) {
                $token = $this->getRequest()->getPost('token');
                $region = $this->getRequest()->getPost('region');
            }

            if ($token) {
                $this->helper->setAccountToken($token);
                $this->helper->setRegion($region);
                $this->userWebTokenManager->deleteAllUserWebToken();
                $this->messageManager->addSuccess(__('Login successful!'));
            }

            $resultRedirect = $this->resultRedirectFactory->create();

            if ($this->statisticsHelper->sendStatistics('step2')) {
                $this->helper->flushConfigCache();
            }

            return $resultRedirect->setPath('wtai/setup/index');
        } catch (\Exception $e) {
            $this->messageManager->addError($e->getMessage());
        }
    }
}
