<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Controller\Adminhtml\Edit\KeywordsOptimization;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use WriteTextAI\WriteTextAI\Model\Api\Keywords;

class GetList extends Action
{
    /**
     * @var Keywords
     */
    protected $keywords;

    /**
     * Constructor
     *
     * @param Context $context
     * @param Keywords $keywords
     */
    public function __construct(
        Context $context,
        Keywords $keywords
    ) {
        $this->keywords = $keywords;
        parent::__construct($context);
    }

    /**
     * Execute action
     *
     * @return \Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        $response = $this->resultFactory->create(ResultFactory::TYPE_JSON);

        try {
            $apiResponse = $this->keywords->getOptimizationList(
                $this->getRequest()->getParam('store_id'),
                $this->getRequest()->getParam('status'),
                null,
                $this->getRequest()->getParam('entity_type') ?? 'Product',
                $this->getRequest()->getParam('record_ids'),
            );
            $result = [
                'success' => true,
                'api_response' => $apiResponse
            ];
        } catch (\Exception $e) {
            $message = $e->getMessage();
            if (!$message) {
                $message = __(
                    'A system error has occurred. Please try again. If the issue persists,'
                    . ' please contact our support team at support@writetext.ai.'
                );
            }

            $result = [
                'error' => $message,
                'trace' => $e->getTrace()
            ];
        }
        
        $response->setData($result);

        return $response;
    }
}
