<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Block\Adminhtml\Grid;

use Magento\Backend\Block\Template\Context;
use WriteTextAI\WriteTextAI\Helper\Data;
use WriteTextAI\WriteTextAI\Model\Config\Source\ProductAttributes;
use WriteTextAI\WriteTextAI\Model\Config\Source\TriggerActions;
use WriteTextAI\WriteTextAI\Model\Config\Source\AutomaticTextOptimization;
use WriteTextAI\WriteTextAI\Model\GenerateOptionsManager;
use WriteTextAI\WriteTextAI\Model\UserFieldsSelectedManager;
use WriteTextAI\WriteTextAI\ViewModel\Tooltip;
use WriteTextAI\WriteTextAI\ViewModel\Permissions;
use WriteTextAI\WriteTextAI\ViewModel\Settings;
use WriteTextAI\WriteTextAI\ViewModel\UserFieldsSelected;
use WriteTextAI\WriteTextAI\Model\Config\Source\ProductTexts;
use WriteTextAI\WriteTextAI\Model\Config\Source\DefaultValues\ProductTexts as DefaultProductTexts;
use WriteTextAI\WriteTextAI\Helper\CronStatus;
use Magento\Framework\View\LayoutInterface;
use WriteTextAI\WriteTextAI\ViewModel\TemplateSettings;

class FullAutomationPrompt extends Prompt
{
    /**
     * @var string
     */
    protected $_template = 'WriteTextAI_WriteTextAI::grid/massactions/full_automation_prompt.phtml';

    /**
     * @var CronStatus
     */
    protected $cronStatus;
    
    /**
     * @var LayoutInterface
     */
    protected $layout;
    
    /**
     * @var TemplateSettings
     */
    protected $templateSettings;

    /**
     * Constructor
     *
     * @param Context $context
     * @param Data $helper
     * @param ProductAttributes $attributes
     * @param GenerateOptionsManager $generateOptionsManager
     * @param UserFieldsSelected $userFieldsSelected
     * @param Tooltip $tooltip
     * @param Permissions $permissions
     * @param Settings $settings
     * @param UserFieldsSelectedManager $userFieldsSelectedManager
     * @param LayoutInterface $layout
     * @param TemplateSettings $templateSettings
     * @param ProductTexts $productTexts
     * @param DefaultProductTexts $defaultProductTexts
     * @param CronStatus $cronStatus
     * @param array $data
     */
    public function __construct(
        Context $context,
        Data $helper,
        ProductAttributes $attributes,
        GenerateOptionsManager $generateOptionsManager,
        UserFieldsSelected $userFieldsSelected,
        Tooltip $tooltip,
        Permissions $permissions,
        Settings $settings,
        UserFieldsSelectedManager $userFieldsSelectedManager,
        LayoutInterface $layout,
        TemplateSettings $templateSettings,
        ProductTexts $productTexts,
        DefaultProductTexts $defaultProductTexts,
        CronStatus $cronStatus,
        array $data = []
    ) {
        parent::__construct(
            $context,
            $helper,
            $attributes,
            $generateOptionsManager,
            $userFieldsSelected,
            $tooltip,
            $permissions,
            $settings,
            $userFieldsSelectedManager,
            $layout,
            $templateSettings,
            $productTexts,
            $defaultProductTexts,
            $cronStatus,
            $data
        );
        $this->cronStatus = $cronStatus;
        $this->layout = $layout;
        $this->templateSettings = $templateSettings;
    }

    /**
     * Get formatted auto transfer time label (HH:mm <timezone>)
     *
     * @return string
     */
    public function getAutoTransferTimeLabel(): string
    {
        return $this->helper->getAutoTransferTimeLabel();
    }

    /**
     * Get fields selected
     *
     * @return array
     */
    public function getFieldsSelected()
    {
        return $this->userFieldsSelected->getUserFieldsSelected(
            UserFieldsSelectedManager::ACTION_TYPE_BULK_FULL_AUTOMATION_FIELDS,
            'product',
            'grid'
        );
    }
}
