<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Block\Adminhtml\Edit;

use Magento\Backend\Block\Template\Context;
use WriteTextAI\WriteTextAI\Model\OptionSource\Filter\Stores;

class TransferSettings extends \Magento\Backend\Block\Template
{
    /**
     * @var string
     */
    protected $_template = 'WriteTextAI_WriteTextAI::edit/transfer-settings.phtml';

    /**
     * @var Stores
     */
    protected $stores;

    /**
     * Constructor
     *
     * @param Context $context
     * @param Stores $stores
     * @param array $data
     */
    public function __construct(
        Context $context,
        Stores $stores,
        array $data = []
    ) {
        $this->stores = $stores;
        parent::__construct($context, $data);
    }

    /**
     * Get stores
     *
     * @return array
     */
    public function getStores()
    {
        return $this->stores->toOptionArray();
    }
}
