<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Api;

use Magento\Framework\Api\SearchCriteriaInterface;

interface UserFieldsSelectedRepositoryInterface
{
    /**
     * Save UserFieldsSelected
     *
     * @param \WriteTextAI\WriteTextAI\Api\Data\UserFieldsSelectedInterface $userFieldsSelected
     * @return \WriteTextAI\WriteTextAI\Api\Data\UserFieldsSelectedInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function save(
        \WriteTextAI\WriteTextAI\Api\Data\UserFieldsSelectedInterface $userFieldsSelected
    );

    /**
     * Retrieve UserFieldsSelected
     *
     * @param string $userfieldsselectedId
     * @return \WriteTextAI\WriteTextAI\Api\Data\UserFieldsSelectedInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function get($userfieldsselectedId);

    /**
     * Retrieve UserFieldsSelected matching the specified criteria.
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     * @return \WriteTextAI\WriteTextAI\Api\Data\UserFieldsSelectedSearchResultsInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function getList(
        \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
    );

    /**
     * Delete UserFieldsSelected
     *
     * @param \WriteTextAI\WriteTextAI\Api\Data\UserFieldsSelectedInterface $userFieldsSelected
     * @return bool true on success
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function delete(
        \WriteTextAI\WriteTextAI\Api\Data\UserFieldsSelectedInterface $userFieldsSelected
    );

    /**
     * Delete UserFieldsSelected by ID
     *
     * @param string $userfieldsselectedId
     * @return bool true on success
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function deleteById($userfieldsselectedId);
}
