<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */
declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Api\Data;

interface AiCategoryInterface
{
    public const AICATEGORY_ID = 'categories_id';
    
    public const OTHER_DETAILS_CHECKED = 'other_details_checked';
    
    public const EDITED_AT = 'edited_at';
    
    public const REFRESH_AT = 'refresh_at';
    
    public const REVIEWED_AT = 'reviewed_at';
    
    public const TRANSFERRED_AT = 'transferred_at';
    
    public const GENERATED_AT = 'generated_at';
    
    public const CATEGORY_ID = 'category_id';
    
    public const REPRESENTATIVE_PRODUCTS_SELECTED = 'representative_products_selected';
    
    public const STORE_ID = 'store_id';
    
    public const OTHER_DETAILS = 'other_details';

    /**
     * Get categories_id
     *
     * @return string|null
     */
    public function getAicategoryId();

    /**
     * Set categories_id
     *
     * @param string $aicategoryId
     * @return \WriteTextAI\WriteTextAI\AiCategory\Api\Data\AiCategoryInterface
     */
    public function setAicategoryId($aicategoryId);

    /**
     * Get category_id
     *
     * @return string|null
     */
    public function getCategoryId();

    /**
     * Set category_id
     *
     * @param string $categoryId
     * @return \WriteTextAI\WriteTextAI\AiCategory\Api\Data\AiCategoryInterface
     */
    public function setCategoryId($categoryId);

    /**
     * Get store_id
     *
     * @return string|null
     */
    public function getStoreId();

    /**
     * Set store_id
     *
     * @param string $storeId
     * @return \WriteTextAI\WriteTextAI\AiCategory\Api\Data\AiCategoryInterface
     */
    public function setStoreId($storeId);

    /**
     * Get representative_products_selected
     *
     * @return string|null
     */
    public function getRepresentativeProductsSelected();

    /**
     * Set representative_products_selected
     *
     * @param string $representativeProductsSelected
     * @return \WriteTextAI\WriteTextAI\AiCategory\Api\Data\AiCategoryInterface
     */
    public function setRepresentativeProductsSelected($representativeProductsSelected);

    /**
     * Get other_details_checked
     *
     * @return string|null
     */
    public function getOtherDetailsChecked();

    /**
     * Set other_details_checked
     *
     * @param string $otherDetailsChecked
     * @return \WriteTextAI\WriteTextAI\AiCategory\Api\Data\AiCategoryInterface
     */
    public function setOtherDetailsChecked($otherDetailsChecked);

    /**
     * Get other_details
     *
     * @return string|null
     */
    public function getOtherDetails();

    /**
     * Set other_details
     *
     * @param string $otherDetails
     * @return \WriteTextAI\WriteTextAI\AiCategory\Api\Data\AiCategoryInterface
     */
    public function setOtherDetails($otherDetails);

    /**
     * Get generated_at
     *
     * @return string|null
     */
    public function getGeneratedAt();

    /**
     * Set generated_at
     *
     * @param string $generatedAt
     * @return \WriteTextAI\WriteTextAI\AiCategory\Api\Data\AiCategoryInterface
     */
    public function setGeneratedAt($generatedAt);

    /**
     * Get edited_at
     *
     * @return string|null
     */
    public function getEditedAt();

    /**
     * Set edited_at
     *
     * @param string $editedAt
     * @return \WriteTextAI\WriteTextAI\AiCategory\Api\Data\AiCategoryInterface
     */
    public function setEditedAt($editedAt);

    /**
     * Get transferred_at
     *
     * @return string|null
     */
    public function getTransferredAt();

    /**
     * Set transferred_at
     *
     * @param string $transferredAt
     * @return \WriteTextAI\WriteTextAI\AiCategory\Api\Data\AiCategoryInterface
     */
    public function setTransferredAt($transferredAt);

    /**
     * Get refresh_at
     *
     * @return string|null
     */
    public function getRefreshAt();

    /**
     * Set refresh_at
     *
     * @param string $refreshAt
     * @return \WriteTextAI\WriteTextAI\AiCategory\Api\Data\AiCategoryInterface
     */
    public function setRefreshAt($refreshAt);

    /**
     * Get reviewed_at
     *
     * @return string|null
     */
    public function getReviewedAt();

    /**
     * Set reviewed_at
     *
     * @param string $reviewedAt
     * @return \WriteTextAI\WriteTextAI\AiCategory\Api\Data\AiCategoryInterface
     */
    public function setReviewedAt($reviewedAt);
}
