<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Api;

use Magento\Framework\Api\SearchCriteriaInterface;

interface BulkGenerateRequestsRepositoryInterface
{

    /**
     * Save bulk_generate_requests
     *
     * @param \WriteTextAI\WriteTextAI\Api\Data\BulkGenerateRequestsInterface $bulkGenerateRequests
     * @return \WriteTextAI\WriteTextAI\Api\Data\BulkGenerateRequestsInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function save(
        \WriteTextAI\WriteTextAI\Api\Data\BulkGenerateRequestsInterface $bulkGenerateRequests
    );

    /**
     * Retrieve bulk_generate_requests
     *
     * @param string $bulkGenerateRequestsId
     * @return \WriteTextAI\WriteTextAI\Api\Data\BulkGenerateRequestsInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function get($bulkGenerateRequestsId);

    /**
     * Retrieve bulk_generate_requests matching the specified criteria.
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     * @return \WriteTextAI\WriteTextAI\Api\Data\BulkGenerateRequestsSearchResultsInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function getList(
        \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
    );

    /**
     * Delete bulk_generate_requests
     *
     * @param \WriteTextAI\WriteTextAI\Api\Data\BulkGenerateRequestsInterface $bulkGenerateRequests
     * @return bool true on success
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function delete(
        \WriteTextAI\WriteTextAI\Api\Data\BulkGenerateRequestsInterface $bulkGenerateRequests
    );

    /**
     * Delete bulk_generate_requests by ID
     *
     * @param string $bulkGenerateRequestsId
     * @return bool true on success
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function deleteById($bulkGenerateRequestsId);
}
