/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

define([
    'jquery',
    'ko',
    'uiComponent',
    'WriteTextAI_WriteTextAI/js/model/total-credits',
    'WriteTextAI_WriteTextAI/js/model/pro-badge',
    'Magento_Ui/js/modal/modal'
], function ($, ko, Component, totalCredits, proBadge) {
    'use strict';

    /**
     * @var {Component} self
     */
    var self;

    return Component.extend({
        defaults: {
            selectors: {
                modal: '.wtai-no-more-trial-credits-popup-modal',
                overlay: '.wtai-no-more-trial-credits-popup-overlay',
            },
            classes: {
                modal: 'wtai-no-more-trial-credits-popup-modal',
                overlay: 'wtai-no-more-trial-credits-popup-overlay'
            }
        },

        popup: null,
    
        /** @inheritdoc */
        initialize: function () {
            this._super();
    
            self = this;

            $('.wtai-no-more-trial-credits-popup-modal > *').applyBindings(this);
    
            this.initModal();

            this.showPopup.subscribe(function (showPopup) {
                if (showPopup) {
                    self.popup.modal('openModal');
                }
            });
        },

        /** @inheritdoc */
        initObservable: function () {
            this._super().observe([]);

            this.showPopup = ko.computed(function () {
                return proBadge.showNoMoreTrialCredits();
            }, this);
    
            return this;
        },

        /**
         * Initialize history log modal.
         */
        initModal: function () {
            this.popup = $(this.selectors.modal).modal({
                innerScroll: true,
                modalClass: self.classes.modal,
                overlayClass: self.classes.overlay,
                outerClickHandler: function () {
                    $(this.selectors.modal).modal('closeModal');
                }.bind(this),
                buttons: [],
                closed: function () {
                    $(self.selectors.overlay).remove();
                    self.save();
                    totalCredits.noCreditsFreeTrial(false);
                }
            });

            $(this.selectors.modal).css('display', 'block');

            if (this.showPopupOnLoad) {
                this.popup.modal('openModal');
            }
        },

        /**
         * Save guide steps checkbox
         */
        save: function () {
            var url = self.saveUrl;

            $.ajax({
                url: url,
                type: 'POST',
                data: {
                    type: 'no_more_trial_credits'
                },
                dataType: 'json',
                showWriteTextAILoader: false,
                success: function (response) {
                    if (!response.success) {
                        console.log(response.message);
                    }
                }
            });
        },

        /**
         * Component-specific close popup function to avoid naming conflicts
         */
        closeNoMoreTrialCreditsPopup: function () {
            this.popup.modal('closeModal');
        }
    });
});
