/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

define([
    'underscore',
    'Magento_Ui/js/grid/columns/multiselect',
    'WriteTextAI_WriteTextAI/js/model/edit',
    'WriteTextAI_WriteTextAI/js/model/grid/bulk-actions'
], function (_, Multiselect, editData, bulkActionsData) {
    'use strict';

    return Multiselect.extend({
        /** @inheritdoc */
        initialize: function () {
            this._super();

            editData.opened.subscribe(function () {
                this.deselectAll();
            }, this);

            bulkActionsData.disabledRowIds.subscribe(function (disabledRowIds) {
                _.each(disabledRowIds, function (disabledRowId) {
                    this.deselect(disabledRowId);
                }, this);
            }, this);
        }
    });
});
