/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

define([
    "jquery",
    "ko",
    "mage/translate",
    "uiComponent",
    "underscore",
    'WriteTextAI_WriteTextAI/js/model/grid/upload-images',
    'WriteTextAI_WriteTextAI/js/model/grid/keyword-invalid-image-popup',
    "Magento_Ui/js/modal/modal"
], function (
    $,
    ko,
    $t,
    Component,
    _,
    uploadImages,
    keywordInvalidImagePopupModel
) {
    'use strict';

    return Component.extend({
        defaults: {},

        /** @inheritdoc */
        initialize: function () {
            this._super();

            this.initModal();
        },

        /** @inheritdoc */
        initObservable: function () {
            this._super()
                .observe([]);

            this.failedImages = ko.computed(function () {
                return uploadImages.failedImages();
            });

            this.invalid = ko.computed(function () {
                return uploadImages.invalid().slice(0, 10);
            });

            this.notSupported = ko.computed(function () {
                return uploadImages.notSupported().slice(0, 10);
            });

            this.downloadFailed = ko.computed(function () {
                return uploadImages.downloadFailed().slice(0, 10);
            });

            this.general = ko.computed(function () {
                return uploadImages.general().slice(0, 10);
            });

            this.errorMessages = ko.computed(function () {
                return uploadImages.errorMessages();
            });

            return this;
        },

        /**
         * Initialize modal
         */
        initModal: function () {
            $('.wtai-grid-keyword-invalid-image-popup').modal({
                type: 'popup',
                responsive: true,
                title: $t('Some images could not be processed:'),
                modalClass: 'wtai-grid-keyword-invalid-image-popup-modal',
                overlayClass: 'modals-overlay wtai-grid-keyword-invalid-image-popup-overlay',
                buttons: [{
                    text: $t('Cancel'),
                    class: 'action-secondary action-dismiss',
                    click: function () {
                        this.closeModal();
                    }
                }, {
                    text: $t('Proceed'),
                    class: 'action-primary wtai-action-proceed',
                    click: function () {
                        var self = keywordInvalidImagePopupModel.self(),
                            action = keywordInvalidImagePopupModel.action(),
                            data = keywordInvalidImagePopupModel.data(),
                            settings = keywordInvalidImagePopupModel.settings();

                        self.bulkKeywordAnalysisRequest(self, action, data, settings);

                        this.closeModal();
                    }
                }],
                closed: function () {
                    $('.modals-overlay.wtai-grid-keyword-invalid-image-popup-overlay').remove();
                }
            });

            $('.wtai-grid-keyword-invalid-image-popup').removeClass('wtai-no-display');
        },
    });
});
