/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

define([
    'jquery',
    'ko',
    'uiComponent',
    'mage/translate',
    'WriteTextAI_WriteTextAI/js/model/grid/listing',
    'WriteTextAI_WriteTextAI/js/model/grid/popups/image-upload-progressbar'
], function (
    $,
    ko,
    Component,
    $t,
    listingModel,
    imageUploadProgressbarModel
) {
    'use strict';

    /**
     * @var {Object} self
     */
    var self;

    return Component.extend({
        defaults: {
        },

        /** @inheritdoc */
        initialize: function () {
            this._super();

            self = this;
        },

        /** @inheritdoc */
        initObservable: function () {
            this._super()
                .observe([
                ]);

            this.count = ko.computed(function () {
                var progress = imageUploadProgressbarModel.progress();
                var total = imageUploadProgressbarModel.total();

                if (total !== 0) {
                    return $t('%p / %t image/s').replace('%p', progress).replace('%t', total);
                }
            });

            this.user = ko.computed(function () {
                return listingModel.currentUser().name;
            });

            this.email = ko.computed(function () {
                return listingModel.currentUser().email;
            });

            this.visible = ko.computed(function () {
                return imageUploadProgressbarModel.visible();
            });

            this.progress = ko.computed(function () {
                var progress = imageUploadProgressbarModel.progress();
                var total = imageUploadProgressbarModel.total();
                return Math.round((progress / total) * 100);
            });

            this.cancelDisabled = ko.computed(function () {
                return imageUploadProgressbarModel.toCancel();
            });

            this.isKeywordAnalysis = ko.computed(function () {
                return imageUploadProgressbarModel.isKeywordAnalysis();
            });

            return this;
        },

        /**
         * Cancel upload
         */
        cancelUpload: function () {
            imageUploadProgressbarModel.toCancel(true);
        }
    });
});
