/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

define([
    'jquery',
    'uiComponent',
    'underscore',
    'WriteTextAI_WriteTextAI/js/model/grid/error-messages'
], function (
    $,
    Component,
    _,
    errorMessagesModel
) {
    'use strict';

    /**
     * @var {Component} self
     */
    var self;

    return Component.extend({
        defaults: {
            messages: [],
            successMessages: []
        },

        /** @inheritdoc */
        initialize: function () {
            this._super();

            self = this;

            errorMessagesModel.messages.subscribe(function (messages) {
                self.messages(messages);
            });

            errorMessagesModel.successMessages.subscribe(function (successMessages) {
                self.successMessages(successMessages);
            });
        },

        /** @inheritdoc */
        initObservable: function () {
            this._super().observe(['messages', 'successMessages']);

            return this;
        },

        /**
         * Remove message
         *
         * @param {Object} message
         * @returns {void}
         */
        dismissMessage: function (message) {
            self.messages.remove(message);
        }
    });
});
