/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

define([
    'jquery',
    'ko',
    'uiComponent',
    'underscore',
    'WriteTextAI_WriteTextAI/js/model/edit/select-template',
    'WriteTextAI_WriteTextAI/js/model/edit/product',
    'WriteTextAI_WriteTextAI/js/categories/model/edit'
], function (
    $,
    ko,
    Component,
    _,
    selectTemplateModel,
    product,
    categoryEditData
) {
    'use strict';

    /**
     * @var {Component} self
     */
    var self;

    return Component.extend({
        defaults: {
            templateOptions: [],
            selectedTemplateValue: {
                page_title: ko.observable(''),
                product_description: ko.observable(''),
                short_product_description: ko.observable(''),
                category_page_title: ko.observable(''),
                category_description: ko.observable('')
            },
            field: '',
            entityType: '',
            saveUrl: '',
            productId: '',
            storeId: '',
            gettingData: null
        },
        initialize: function () {
            this._super();
            /*this.templateOptions = ko.observableArray(this.initialTemplates || []);*/

            self = this;

            product.productId.subscribe(function (productId) {
                self.productId(productId);
            });

            product.storeId.subscribe(function (storeId) {
                self.storeId(storeId);
            });

            selectTemplateModel.selectedTemplates.page_title.subscribe(function (value) {
                this.selectedTemplateValue.page_title(value);
            }, this);

            selectTemplateModel.selectedTemplates.product_description.subscribe(function (value) {
                this.selectedTemplateValue.product_description(value);
            }, this);

            selectTemplateModel.selectedTemplates.short_product_description.subscribe(function (value) {
                this.selectedTemplateValue.short_product_description(value);
            }, this);

            selectTemplateModel.selectedTemplates.category_page_title.subscribe(function (value) {
                this.selectedTemplateValue.category_page_title(value);
            }, this);

            selectTemplateModel.selectedTemplates.category_description.subscribe(function (value) {
                this.selectedTemplateValue.category_description(value);
            }, this);

            selectTemplateModel.templateOptions.subscribe(function (value) {
                this.templateOptions(value[this.field]);
            }, this);
        },

        initObservable: function () {
            this._super().observe([
                'productId',
                'storeId',
                'templateOptions'
            ]);

            return this;
        },

        /**
         * On template change
         *
         * @param {string} field
         * @param {Event} event
         */
        onTemplateChange: function (field, event) {
            const newValue = event.target.value;
            selectTemplateModel.selectedTemplates[field](newValue);
        },
    });
});