/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

define([
    'uiComponent',
    'underscore',
    'WriteTextAI_WriteTextAI/js/model/edit/keywords/error-messages'
], function (
    Component,
    _,
    errorMessagesModel
) {
    'use strict';

    /**
     * @var {Component} self
     */
    var self;

    return Component.extend({
        defaults: {
            messages: []
        },

        /** @inheritdoc */
        initialize: function () {
            this._super();

            self = this;

            errorMessagesModel.messages.subscribe(function (messages) {
                self.messages(messages);
            });
        },

        /** @inheritdoc */
        initObservable: function () {
            this._super().observe(['messages']);

            return this;
        },

        /**
         * Remove message
         *
         * @param {Object} message
         * @returns {void}
         */
        dismissMessage: function (message) {
            self.messages.remove(message);
        }
    });
});
