/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

define(['ko', 'domReady!'], function (ko) {
    'use strict';

    var pageTitle = ko.observable(),
        pageDescription = ko.observable(),
        categoryDescription = ko.observable(),
        highlightPronouns = ko.observable(),
        formal = ko.observable(),
        mgPageTitle = ko.observable(),
        mgPageDescription = ko.observable(),
        mgCategoryDescription = ko.observable(),
        originalPageTitle = ko.observable(),
        originalPageDescription = ko.observable(),
        originalCategoryDescription = ko.observable(),
        selectedFields = ko.observableArray([]),
        statuses = ko.observable({
            pageTitleGenerateStatus: false,
            pageDescriptionGenerateStatus: false,
            categoryDescriptionGenerateStatus: false,
            pageTitleTransferStatus: false,
            pageDescriptionTransferStatus: false,
            categoryDescriptionTransferStatus: false,
        }),
        useDefault = ko.observable({
            pageTitle: true,
            pageDescription: true,
            categoryDescription: true
        }),
        keywordsUsed = ko.observable({
            pageTitle: [],
            pageDescription: [],
            categoryDescription: []
        });

    return {
        pageTitle: pageTitle,
        pageDescription: pageDescription,
        categoryDescription: categoryDescription,
        highlightPronouns: highlightPronouns,
        formal: formal,
        originalPageTitle: originalPageTitle,
        originalPageDescription: originalPageDescription,
        originalCategoryDescription: originalCategoryDescription,
        mgPageTitle: mgPageTitle,
        mgPageDescription: mgPageDescription,
        mgCategoryDescription: mgCategoryDescription,
        selectedFields: selectedFields,
        statuses: statuses,
        useDefault: useDefault,
        keywordsUsed: keywordsUsed
    };
});
