/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

define([
    'jquery',
    'ko',
    'uiComponent',
    'underscore',
    'WriteTextAI_WriteTextAI/js/categories/model/edit/category'

], function (
    $,
    ko,
    Component,
    _,
    category
) {
    'use strict';

    /**
     * @var {Component} self
     */
    var self;

    return Component.extend({
        defaults: {},

        /** @inheritdoc */
        initialize: function () {
            this._super();

            self = this;

            $('.wtai-category-identifier-container > *').applyBindings(this);
        },

        /** @inheritdoc */
        initObservable: function () {
            this._super()
                .observe([]);

            this.breadcrumbs = ko.computed(function () {
                return category.breadcrumbs();
            });

            return this;
        },
    });
});
