<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\ViewModel;

class Wysiwyg implements \Magento\Framework\View\Element\Block\ArgumentInterface
{
    /**
     * @var \Magento\Cms\Model\Wysiwyg\Config
     */
    protected $wysiwygConfig;

    /**
     * @var \Magento\Framework\Module\Manager
     */
    protected $moduleManager;

    /**
     * @var \Magento\Framework\View\Asset\Repository
     */
    protected $assetRepo;

    /**
     * @param \Magento\Cms\Model\Wysiwyg\Config $wysiwygConfig
     * @param \Magento\Framework\Module\Manager $moduleManager
     * @param \Magento\Framework\View\Asset\Repository $assetRepo
     */
    public function __construct(
        \Magento\Cms\Model\Wysiwyg\Config $wysiwygConfig,
        \Magento\Framework\Module\Manager $moduleManager,
        \Magento\Framework\View\Asset\Repository $assetRepo
    ) {
        $this->wysiwygConfig = $wysiwygConfig;
        $this->moduleManager = $moduleManager;
        $this->assetRepo = $assetRepo;
    }

    /**
     * Retrieve additional html and put it at the end of element html
     *
     * @return string
     */
    public function getWysiwygConfig()
    {
        $config['add_variables'] = false;
        $config['add_widgets'] = false;
        $config['add_directives'] = true;
        $config['container_class'] = 'hor-scroll';
        $config['height'] = '376px';
        $config = $this->wysiwygConfig->getConfig($config);
        $config = $config->getData();

        if (isset($config['tinymce4'])) {
            $wysiwygName = 'tinymce4';
        } elseif (isset($config['tinymce'])) {
            $wysiwygName = 'tinymce';
        }

        $config[$wysiwygName]['toolbar'] = 'styles styleselect |'
            . ' bold italic underline strikethrough |'
            . ' numlist bullist blockquote |'
            . ' alignleft aligncenter alignright |'
            . ' link unlink';

        // removed premium plugins in tinymce 6
        $config[$wysiwygName]['plugins'] = implode(' ', [
            'advlist',
            'autolink',
            'lists',
            'link',
            'charmap',
            'media',
            // 'noneditable',
            'table',
            // 'contextmenu',
            // 'paste',
            'code',
            'help',
            'table',
            // 'textcolor',
            // 'colorpicker'
        ]);

        if (isset($config['plugins']) &&
            is_array($config['plugins']) &&
            !empty($config['plugins'])
        ) {
            /**
             * foreach ($config['plugins'] as $key => $plugin) {
             *     if ($plugin['name'] == 'image') {
             *         unset($config['plugins'][$key]);
             *     }
             * }
             */
            $config['plugins'] = array_values($config['plugins']);
        }

        // Add custom css
        $cssUrl = $this->assetRepo->getUrl('WriteTextAI_WriteTextAI::css/wysiwyg.css');
        $config[$wysiwygName]['content_css'] = $cssUrl;
        $config['settings']['resize'] = false;
        $config['settings']['statusbar'] = false;
        $config = $config;

        return $config;
    }

    /**
     * Check whether wysiwyg enabled or not
     *
     * @return bool
     * @SuppressWarnings(PHPMD.BooleanGetMethodName)
     */
    public function getIsWysiwygEnabled()
    {
        if ($this->moduleManager->isEnabled('Magento_Cms')) {
            return (bool)($this->wysiwygConfig->isEnabled());
        }

        return false;
    }

    /**
     * Retrieve disabled wysiwyg editor configuration
     *
     * @return string
     */
    public function getDisabledWysiwygConfig()
    {
        $config = $this->getWysiwygConfig();
        
        $config['settings']['toolbar'] = false;
        $config['height'] = '413px';
        
        $config['settings']['readonly'] = true;

        return $config;
    }
}
