<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\ViewModel;

use WriteTextAI\WriteTextAI\Helper\Settings;
use Magento\Framework\Module\ModuleListInterface;
use WriteTextAI\WriteTextAI\ViewModel\Settings as SettingsViewModel;

class Popups implements \Magento\Framework\View\Element\Block\ArgumentInterface
{
    public const MODULE_NAME = 'WriteTextAI_WriteTextAI';

    /**
     * @var Settings
     */
    protected $settings;

    /**
     * @var ModuleListInterface
     */
    protected $moduleList;

    /**
     * @var SettingsViewModel
     */
    protected $settingsViewModel;

    /**
     * Constructor
     *
     * @param Settings $settings
     * @param ModuleListInterface $moduleList
     * @param SettingsViewModel $settingsViewModel
     */
    public function __construct(
        Settings $settings,
        ModuleListInterface $moduleList,
        SettingsViewModel $settingsViewModel
    ) {
        $this->settings = $settings;
        $this->moduleList = $moduleList;
        $this->settingsViewModel = $settingsViewModel;
    }

    /**
     * Get new to premium popup
     *
     * @param string $type
     *
     * @return bool
     */
    public function showPopup($type)
    {
        if ($type === 'welcome_new_version') {
            $welcomeNewVersion = $this->settings->conf('writetextai_settings/popups/' . $type);
            $welcomeReferenceVersion = $this->settings->conf('writetextai_settings/popups/' . $type . '_reference');
            return ($welcomeReferenceVersion === $this->getModuleVersion()
                && $welcomeNewVersion !== $this->getModuleVersion());
        }

        $shown = filter_var(
            $this->settings->conf('writetextai_settings/popups/' . $type),
            FILTER_VALIDATE_BOOLEAN
        );

        return !$shown;
    }

    /**
     * Get module version
     *
     * @return string
     */
    protected function getModuleVersion()
    {
        return $this->moduleList->getOne(self::MODULE_NAME)['setup_version'];
    }

    /**
     * Get credits
     *
     * @return int
     */
    public function getCredits()
    {
        return $this->settingsViewModel->getSettings('credits');
    }
}
