<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\ViewModel;

use WriteTextAI\WriteTextAI\Helper\Fields as FieldsHelper;
use WriteTextAI\WriteTextAI\Helper\Data as DataHelper;

class Fields implements \Magento\Framework\View\Element\Block\ArgumentInterface
{
    /**
     * @var FieldsHelper
     */
    protected $helper;

    /**
     * @var DataHelper
     */
    protected $dataHelper;

    /**
     * Constructor
     *
     * @param FieldsHelper $helper
     * @param DataHelper $dataHelper
     */
    public function __construct(
        FieldsHelper $helper,
        DataHelper $dataHelper
    ) {
        $this->helper = $helper;
        $this->dataHelper = $dataHelper;
    }

    /**
     * Get field mappings
     *
     * @return array
     */
    public function getFieldLabels()
    {
        return $this->helper->getFieldLabels();
    }

    /**
     * Get custom open graph
     *
     * @return bool
     */
    public function getCustomOpenGraph()
    {
        return $this->dataHelper->getCustomOpenGraph();
    }
}
