<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\ViewModel;

use WriteTextAI\WriteTextAI\Helper\CronStatus as HelperCronStatus;

class CronStatus implements \Magento\Framework\View\Element\Block\ArgumentInterface
{
    /**
     * @var HelperCronStatus
     */
    protected $cronStatus;

    /**
     * @var array
     */
    protected $data = [];
    
    /**
     * Constructor
     *
     * @param HelperCronStatus $cronStatus
     */
    public function __construct(
        HelperCronStatus $cronStatus
    ) {
        $this->cronStatus = $cronStatus;
    }

    /**
     * Get settings
     *
     * @param bool $reset
     *
     * @return array
     */
    public function getIsCronRunning($reset = false)
    {
        if (isset($this->data['isCronRunning']) && !$reset) {
            return $this->data['isCronRunning'];
        }

        return $this->getValue('isCronRunning');
    }

    /**
     * Set value
     *
     * @param string $name
     * @param array $value
     * @return void
     */
    public function setValue($name, $value)
    {
        $this->data[$name] = $value;
    }
    
    /**
     * Get value
     *
     * @param string $name
     *
     * @return array
     */
    protected function getValue($name)
    {
        $value = $this->cronStatus->isCronRunning();
        $this->setValue($name, $value);

        return $value;
    }
}
