<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\ViewModel;

use WriteTextAI\WriteTextAI\Helper\Data as DataHelper;
use Magento\Catalog\Model\ResourceModel\Eav\AttributeFactory;
use WriteTextAI\WriteTextAI\Helper\Categories\Fields as FieldsHelper;

class AttributeScope implements \Magento\Framework\View\Element\Block\ArgumentInterface
{
    /**
     * @var DataHelper
     */
    protected $dataHelper;

    /**
     * @var AttributeFactory
     */
    protected $attributeFactory;

    /**
     * @var FieldsHelper
     */
    protected $fieldsHelper;

    /**
     * Constructor
     *
     * @param DataHelper $dataHelper
     * @param AttributeFactory $attributeFactory
     * @param FieldsHelper $fieldsHelper
     */
    public function __construct(
        DataHelper $dataHelper,
        AttributeFactory $attributeFactory,
        FieldsHelper $fieldsHelper
    ) {
        $this->dataHelper = $dataHelper;
        $this->attributeFactory = $attributeFactory;
        $this->fieldsHelper = $fieldsHelper;
    }

    /**
     * Get attribute scope
     *
     * @param string $field
     *
     * @return array
     */
    public function getAttrScope($field)
    {
        $html = '';
        $mappingSettings = $this->dataHelper->getMappingSettings();

        if (isset($mappingSettings[$field])) {
            $attributeCode = $mappingSettings[$field];
            $attribute = $this->attributeFactory->create();
            $attribute->loadByCode(\Magento\Catalog\Model\Product::ENTITY, $attributeCode);

            if ($attribute->isScopeGlobal()) {
                $html = __('[GLOBAL]');
            } elseif ($attribute->isScopeWebsite()) {
                $html = __('[WEBSITE]');
            } elseif ($attribute->isScopeStore()) {
                $html = __('[STORE VIEW]');
            }
        }

        return $html;
    }

    /**
     * Check if attribute is global
     *
     * @param string $scope
     *
     * @return bool
     */
    public function isAttributeGlobal($scope)
    {
        return (string)$scope === '[GLOBAL]';
    }

    /**
     * Get category attribute scope
     *
     * @param string $field
     * @return string
     */
    public function getCatAttrScope($field)
    {
        $html = '';
        $mappingSettings = $this->fieldsHelper->getMappingSettings();
        
        $attributeCode = $field;
        if (isset($mappingSettings[$field])) {
            $attributeCode = $mappingSettings[$field];
        }
        
        if (isset($mappingSettings[$field]) || $field === 'image') {
            $attribute = $this->attributeFactory->create();
            $attribute->loadByCode(\Magento\Catalog\Model\Category::ENTITY, $attributeCode);
        
            if ($attribute->isScopeGlobal()) {
                $html = __('[GLOBAL]');
            } elseif ($attribute->isScopeWebsite()) {
                $html = __('[WEBSITE]');
            } elseif ($attribute->isScopeStore()) {
                $html = __('[STORE VIEW]');
            }
        }

        return $html;
    }
}
