<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Plugin\Component;

use Magento\Framework\View\LayoutInterface;

class MassAction
{
    private const MASS_ACTION_NAME = 'listing_massaction';
    
    private const ACTION_TYPES = [
        'generate' => [
            'url' => 'wtai/grid/massGenerate',
            'block' => \WriteTextAI\WriteTextAI\Block\Adminhtml\Grid\Prompt::class,
            'buttonBlock' => \WriteTextAI\WriteTextAI\Block\Adminhtml\Grid\GenerateButton::class,
            'childBlock' => \WriteTextAI\WriteTextAI\Block\Adminhtml\Grid\ProBadge::class
        ],
        'transfer' => [
            'url' => 'wtai/grid/massTransfer',
            'block' => \WriteTextAI\WriteTextAI\Block\Adminhtml\Grid\TransferPrompt::class,
            'childBlock' => \WriteTextAI\WriteTextAI\Block\Adminhtml\Grid\ProBadge::class
        ],
        'keyword_analysis' => [
            'url' => 'wtai/grid/massKeywordAnalysis',
            'block' => \WriteTextAI\WriteTextAI\Block\Adminhtml\Grid\KeywordAnalysisPrompt::class
        ],
        'full_automation' => [
            'url' => 'wtai/grid/massFullAutomation',
            'block' => \WriteTextAI\WriteTextAI\Block\Adminhtml\Grid\FullAutomationPrompt::class,
            'childBlock' => \WriteTextAI\WriteTextAI\Block\Adminhtml\Grid\ProBadge::class
        ]
    ];

    /**
     * @var LayoutInterface
     */
    protected $layout;

    /**
     * Constructor
     *
     * @param LayoutInterface $layout
     */
    public function __construct(
        LayoutInterface $layout
    ) {
        $this->layout = $layout;
    }

    /**
     * Modify mass action popup content
     *
     * @param \Magento\Ui\Component\MassAction $subject
     * @param string $key
     * @param array $value
     * @return array
     */
    public function beforeSetData(
        \Magento\Ui\Component\MassAction $subject,
        string $key,
        array $value
    ): ?array {
        if ($key !== 'config' ||
            $subject->getName() !== self::MASS_ACTION_NAME ||
            !isset($value['actions'])
        ) {
            return null;
        }

        try {
            foreach ($value['actions'] as &$action) {
                $actionType = $action['type'] ?? '';
                if (!isset(self::ACTION_TYPES[$actionType]) ||
                    !isset($action['confirm']['message']) ||
                    stripos($action['url'], self::ACTION_TYPES[$actionType]['url']) === false
                ) {
                    continue;
                }

                $action['confirm']['message'] = $this->createBlockContent(
                    $action,
                    'block',
                    true
                );

                if ($actionType === 'generate' && isset(self::ACTION_TYPES[$actionType]['buttonBlock'])) {
                    $action['confirm']['button'] = $this->createBlockContent(
                        $action,
                        'buttonBlock'
                    );
                }

                if ($actionType === 'full_automation' && isset(self::ACTION_TYPES[$actionType]['buttonBlock'])) {
                    $action['confirm']['button'] = $this->createBlockContent(
                        $action,
                        'buttonBlock'
                    );
                }
            }
        } catch (\Exception $e) {
            throw new \Exception($e->getMessage());
        }

        return [$key, $value];
    }

    /**
     * Create block content
     *
     * @param array $action
     * @param string $blockType
     * @param bool $hasChildBlock
     * @return string
     */
    private function createBlockContent(array $action, string $blockType, $hasChildBlock = false): string
    {
        $block = $this->layout->createBlock(self::ACTION_TYPES[$action['type']][$blockType]);
        
        if ($hasChildBlock && isset(self::ACTION_TYPES[$action['type']]['childBlock'])) {
            $childBlock = $this->layout->createBlock(self::ACTION_TYPES[$action['type']]['childBlock']);
            $block->setChild('wtai.pro.badge.' . $action['type'], $childBlock);
        }
        
        return $block->toHtml();
    }
}
