<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Observer;

use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use WriteTextAI\WriteTextAI\Model\SettingManager;

class PrepareSettings implements ObserverInterface
{
    /**
     * @var SettingManager
     */
    protected $settingManager;

    /**
     * Constructor
     *
     * @param SettingManager $settingManager
     */
    public function __construct(
        SettingManager $settingManager
    ) {
        $this->settingManager = $settingManager;
    }

    /**
     * Execute observer
     *
     * @param Observer $observer
     * @return void
     */
    public function execute(Observer $observer)
    {
        $this->settingManager->syncSettings();
    }
}
