<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Model;

use WriteTextAI\WriteTextAI\Model\UserFeedbackFactory;
use WriteTextAI\WriteTextAI\Api\UserFeedbackRepositoryInterface;

class UserFeedbackManager
{
    /**
     * @var UserFeedbackFactory
     */
    protected $userFeedbackFactory;

    /**
     * @var UserFeedbackRepositoryInterface
     */
    protected $userFeedbackRepository;

    /**
     * Constructor
     *
     * @param UserFeedbackFactory $userFeedbackFactory
     * @param UserFeedbackRepositoryInterface $userFeedbackRepository
     */
    public function __construct(
        UserFeedbackFactory $userFeedbackFactory,
        UserFeedbackRepositoryInterface $userFeedbackRepository
    ) {
        $this->userFeedbackFactory = $userFeedbackFactory;
        $this->userFeedbackRepository = $userFeedbackRepository;
    }

    /**
     * If user feedback belongs to user
     *
     * @param int $userId
     * @param string $feedbackId
     *
     * @return bool
     */
    public function belongsToUser($userId, $feedbackId)
    {
        $userFeedback = $this->userFeedbackFactory->create();
        $userFeedback = $userFeedback->getCollection()
            ->addFieldToFilter('user_id', $userId)
            ->addFieldToFilter('feedback_id', $feedbackId)
            ->getFirstItem();
        if ($userFeedback->getId()) {
            return true;
        } else {
            return false;
        }
    }
}
