<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

 declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Model;

use Magento\Framework\Model\AbstractModel;
use WriteTextAI\WriteTextAI\Api\Data\UserFeedbackInterface;

class UserFeedback extends AbstractModel implements UserFeedbackInterface
{

    /**
     * @inheritDoc
     */
    public function _construct()
    {
        $this->_init(\WriteTextAI\WriteTextAI\Model\ResourceModel\UserFeedback::class);
    }

    /**
     * @inheritDoc
     */
    public function getUserFeedbackId()
    {
        return $this->getData(self::USER_FEEDBACK_ID);
    }

    /**
     * @inheritDoc
     */
    public function setUserFeedbackId($userFeedbackId)
    {
        return $this->setData(self::USER_FEEDBACK_ID, $userFeedbackId);
    }

    /**
     * @inheritDoc
     */
    public function getUserId()
    {
        return $this->getData(self::USER_ID);
    }

    /**
     * @inheritDoc
     */
    public function setUserId($userId)
    {
        return $this->setData(self::USER_ID, $userId);
    }

    /**
     * @inheritDoc
     */
    public function getFeedbackId()
    {
        return $this->getData(self::FEEDBACK_ID);
    }

    /**
     * @inheritDoc
     */
    public function setFeedbackId($feedbackId)
    {
        return $this->setData(self::FEEDBACK_ID, $feedbackId);
    }
}
