<?php
declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Model;

use WriteTextAI\WriteTextAI\Api\PingInterface;
use WriteTextAI\WriteTextAI\Api\Data\PingResultInterfaceFactory;

/**
 * Class Ping
 * Simple ping endpoint implementation for testing API connectivity
 */
class Ping implements PingInterface
{
    /**
     * @var PingResultInterfaceFactory
     */
    private $pingResultFactory;

    /**
     * @param PingResultInterfaceFactory $pingResultFactory
     */
    public function __construct(
        PingResultInterfaceFactory $pingResultFactory
    ) {
        $this->pingResultFactory = $pingResultFactory;
    }
    /**
     * Test API connection
     *
     * @return \WriteTextAI\WriteTextAI\Api\Data\PingResultInterface
     */
    public function ping()
    {
        $result = $this->pingResultFactory->create();
        $result->setSuccess(true);
        return $result;
    }
}
