<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Model\OptionSource\Filter;

use Magento\Framework\Data\OptionSourceInterface;

class AiStatus extends Fields implements OptionSourceInterface
{
    /*
     * Statuses
     */
    public const ALL = 'all';

    public const NOT_GENERATED = 'not_generated';

    public const WRITETEXTAI = 'writetextai';

    public const NO_ACTIVITY = 'no_activity';

    public const IMAGE_ALT_TEXT = 'image_alt_text';

    /*
     * WriteText.ai Statuses
     */
    public const GENERATED = 'Generated';

    public const TRANSFERRED = 'Transferred';

    public const EDITED = 'Edited';

    public const REVIEWED = 'Reviewed';

    public const FOR_TRANSFERRING = 'ForTransferring';

    /**
     * Get options
     *
     * @return array
     */
    public function toOptionArray()
    {
        $fields = [
            [
                'value' => self::PAGE_TITLE,
                'label' => __('Meta title')
            ],
            [
                'value' => self::PAGE_DESCRIPTION,
                'label' => __('Meta description')
            ],
            [
                'value' => self::PRODUCT_DESCRIPTION,
                'label' => __('Description')
            ],
            [
                'value' => self::EXCERPT,
                'label' => __('Short description')
            ]
        ];

        if ($this->helper->getCustomOpenGraph()) {
            $fields[] = [
                'value' => self::OPEN_GRAPH,
                'label' => __('Open Graph text')
            ];
        }

        $fields[] = [
            'value' => self::IMAGE_ALT_TEXT,
            'label' => __('Image alt text')
        ];

        // Get automatic text optimization for filters
        $automaticTextOptimizationFilters = $this->helper->getAutomaticTextOptimizationOptions(true);

        $statuses = [
            'fields' => $fields,
            'statuses' => [
                [
                    'value' => self::ALL,
                    'label' => __('All')
                ],
                [
                    'value' => self::NOT_GENERATED,
                    'label' => __('Not generated')
                ],
                [
                    'value' => self::WRITETEXTAI,
                    'label' => __('WriteText.ai status')
                ]
            ],
            'ai_statuses' => [
                [
                    'value' => self::GENERATED,
                    'label' => __('Generated')
                ],
                [
                    'value' => self::EDITED,
                    'label' => __('Edited')
                ],
                [
                    'value' => self::REVIEWED,
                    'label' => __('Reviewed')
                ],
                [
                    'value' => self::FOR_TRANSFERRING,
                    'label' => __('Queued for transfer')
                ],
                [
                    'value' => self::TRANSFERRED,
                    'label' => __('Transferred')
                ]
            ],
            'no_activity_value' => [
                'value' => self::NO_ACTIVITY,
                'label' => __('No Activity')
            ],
            'writetextai_status_value' => [
                'value' => self::WRITETEXTAI,
                'label' => __('WriteText.ai status')
            ],
            'automatic_text_optimization' => $automaticTextOptimizationFilters
        ];

        return $statuses;
    }
}
