<?php
declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Model\Data;

use WriteTextAI\WriteTextAI\Api\Data\PingResultInterface;
use Magento\Framework\DataObject;

/**
 * Class PingResult
 * Ping response data model
 */
class PingResult extends DataObject implements PingResultInterface
{
    const SUCCESS = 'success';

    /**
     * {@inheritdoc}
     */
    public function getSuccess()
    {
        return $this->getData(self::SUCCESS);
    }

    /**
     * {@inheritdoc}
     */
    public function setSuccess($success)
    {
        return $this->setData(self::SUCCESS, $success);
    }
}
