<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;
use WriteTextAI\WriteTextAI\Helper\Data;

class ProductTexts implements OptionSourceInterface
{
    /**
     * @var Data
     */
    protected $helper;

    /**
     * Constructor
     *
     * @param Data $helper
     */
    public function __construct(
        Data $helper
    ) {
        $this->helper = $helper;
    }

    /**
     * Get options
     *
     * @return array
     */
    public function toOptionArray()
    {
        $defaultProductTexts = [
            "page_title" => __('Meta title'),
            "page_description" => __('Meta description'),
            "product_description" => __('Product description'),
            "short_product_description" => __('Product short description')
        ];
        if ($this->helper->getCustomOpenGraph()) {
            $defaultProductTexts['open_graph'] = __('Open Graph text');
        }
        
        $options = [];
        foreach ($defaultProductTexts as $key => $value) {
            $options[] = [
                'value' => $key,
                'label' => __($value)
            ];
        }

        return $options;
    }
}
