<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Model\Config\Source\DefaultValues;

class Styles extends Base
{
    /**
     * Get default styles
     *
     * @return $string
     */
    public function getDefaultValues()
    {
        $locale = $this->getUserLocale();
        $styles = $this->settingManager->getSettings('styles', $locale);
        
        $values = [];
        
        foreach ($styles as $style) {
            if ($style['default'] == true) {
                $values[] = $style['id'];
            }
        }
        
        return implode(',', $values);
    }
}
