<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;

class AutomaticTextOptimization implements OptionSourceInterface
{
    public const AUTO_REWRITE_AND_QUEUE = 'auto_rewrite_and_queue';

    public const FLAG = 'flag';

    public const AUTO_REWRITE_AND_TRANSFER = 'auto_rewrite_and_transfer';

    /**
     * Additional keyword optimization for filters
     */
    public const SHOW_ALL = 'show_all';
    
    public const OPTIMIZED = 'optimized';

    public const NOT_OPTIMIZED = 'not_optimized';

    public const FOR_GENERATION = 'for_generation';

    public const GENERATED = 'generated';

    public const PUBLISHED = 'published';

    /**
     * Get options
     *
     * @return array
     */
    public function toOptionArray()
    {
        
        $options = [
            [
                'value' => self::FLAG,
                'label' => __('Flag for manual review')
            ],
            [
                'value' => self::AUTO_REWRITE_AND_QUEUE,
                'label' => __('Auto regenerate with updated keywords')
            ],
            [
                'value' => self::AUTO_REWRITE_AND_TRANSFER,
                'label' => __('Auto regenerate and transfer')
            ]
        ];
        
        return $options;
    }

    /**
     * Get options for filters
     *
     * @return array
     */
    public function toOptionArrayForFilters()
    {
        $automaticTextOptimization = [
            [
                'value' => self::SHOW_ALL,
                'label' => __('All')
            ], [
                'value' => self::OPTIMIZED,
                'label' => __('With keyword analysis'),
                'options' => [
                    [
                        'value' => self::FOR_GENERATION,
                        'label' => __('Keyword/s not applied in text')
                    ], [
                        'value' => self::GENERATED,
                        'label' => __('Keyword/s applied in text')
                    ], [
                        'value' => self::PUBLISHED,
                        'label' => __('Keyword/s applied in text and transferred to Magento')
                    ]
                ]
            ], [
                'value' => self::NOT_OPTIMIZED,
                'label' => __('No keyword analysis')
            ]
        ];
        
        return $automaticTextOptimization;
    }
}
