<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Model\Categories\OptionSource\Filter;

use Magento\Framework\Data\OptionSourceInterface;
use WriteTextAI\WriteTextAI\Model\OptionSource\Filter\Fields;

class AiStatus extends Fields implements OptionSourceInterface
{
    /*
     * Statuses
     */
    public const ALL = 'all';

    public const NOT_GENERATED = 'not_generated';

    public const WRITETEXTAI = 'writetextai';

    public const NO_ACTIVITY = 'no_activity';

    /*
     * WriteText.ai Statuses
     */
    public const GENERATED = 'Generated';

    public const TRANSFERRED = 'Transferred';

    public const EDITED = 'Edited';

    public const REVIEWED = 'Reviewed';

    public const FOR_TRANSFERRING = 'ForTransferring';

    /**
     * Get options
     *
     * @return array
     */
    public function toOptionArray()
    {
        $categoryMapping = self::CATEGORY_MAPPING;
        $fields = [
            [
                'value' => $categoryMapping['page_title'],
                'label' => __('Meta title')
            ],
            [
                'value' => $categoryMapping['page_description'],
                'label' => __('Meta description')
            ],
            [
                'value' => $categoryMapping['category_description'],
                'label' => __('Category description')
            ]
        ];

        // Get automatic text optimization for filters
        $automaticTextOptimizationFilters = $this->helper->getAutomaticTextOptimizationOptions(true);

        $statuses = [
            'fields' => $fields,
            'statuses' => [
                [
                    'value' => self::ALL,
                    'label' => __('All')
                ],
                [
                    'value' => self::NOT_GENERATED,
                    'label' => __('Not generated')
                ],
                [
                    'value' => self::WRITETEXTAI,
                    'label' => __('WriteText.ai status')
                ]
            ],
            'ai_statuses' => [
                [
                    'value' => self::GENERATED,
                    'label' => __('Generated')
                ],
                [
                    'value' => self::EDITED,
                    'label' => __('Edited')
                ],
                [
                    'value' => self::REVIEWED,
                    'label' => __('Reviewed')
                ],
                [
                    'value' => self::FOR_TRANSFERRING,
                    'label' => __('Queued for transfer')
                ],
                [
                    'value' => self::TRANSFERRED,
                    'label' => __('Transferred')
                ]
            ],
            'no_activity_value' => [
                'value' => self::NO_ACTIVITY,
                'label' => __('No Activity')
            ],
            'writetextai_status_value' => [
                'value' => self::WRITETEXTAI,
                'label' => __('WriteText.ai status')
            ],
            'automatic_text_optimization' => $automaticTextOptimizationFilters
        ];

        return $statuses;
    }
}
