<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Model\Api;

use Magento\User\Model\User;
use Magento\Backend\Model\Auth\Session as AuthSession;

/**
 * @api
 */
class Session
{
    /**
     * @var User
     */
    protected $currentUser;

    /**
     * @var AuthSession
     */
    protected $authSession;

    /**
     * Constructor
     *
     * @param AuthSession $authSession
     */
    public function __construct(
        AuthSession $authSession
    ) {
        $this->authSession = $authSession;
    }

    /**
     * Set current user
     *
     * @param User $user
     *
     * @return void
     */
    public function setCurrentUser($user)
    {
        $this->currentUser = $user;
    }

    /**
     * Get curent user
     *
     * @return User
     */
    public function getCurrentUser()
    {
        if ($currentUser = $this->authSession->getUser()) {
            return $currentUser;
        }
        
        if ($this->currentUser) {
            return $this->currentUser;
        }
    }

    /**
     * Get region independent language
     *
     * @return string
     */
    public function getRegionIndependentLanguage()
    {
        $user = $this->getCurrentUser();
        $locale = $user->getInterfaceLocale();
        $locale = explode('_', (string) $locale);

        return $locale[0];
    }

    /**
     * Get current user
     *
     * @return array
     */
    public function getCurrentUserData()
    {
        $user = $this->getCurrentUser();

        return [
            'id' => $user->getId(),
            'name' => $user->getFirstName() . ' ' . $user->getLastName(),
            'email' => $user->getEmail()
        ];
    }
}
