<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Helper;

use WriteTextAI\WriteTextAI\Model\UserFieldsSelectedManager;
use WriteTextAI\WriteTextAI\ViewModel\UserFieldsSelected;
use Magento\Backend\Model\UrlInterface;

class Grid extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * @var UserFieldsSelected
     */
    protected $userFieldsSelected;

    /**
     * @var UrlInterface
     */
    protected $urlBuilder;

    /**
     * Constructor
     *
     * @param UserFieldsSelected $userFieldsSelected
     * @param UrlInterface $urlBuilder
     */
    public function __construct(
        UserFieldsSelected $userFieldsSelected,
        UrlInterface $urlBuilder
    ) {
        $this->userFieldsSelected = $userFieldsSelected;
        $this->urlBuilder = $urlBuilder;
    }

    /**
     * Get grid settings
     *
     * @param string $entityType
     * @return array
     */
    public function getGridSettings($entityType = '')
    {
        $enableComparisonPopup = $this->userFieldsSelected->getUserFieldsSelected(
            UserFieldsSelectedManager::ACTION_TYPE_ENABLE_COMPARISON_POPUP,
            $entityType,
            'grid'
        );

        return [
            UserFieldsSelectedManager::ACTION_TYPE_ENABLE_COMPARISON_POPUP => filter_var(
                $enableComparisonPopup,
                FILTER_VALIDATE_BOOLEAN
            ),
            'entity_type' => $entityType,
            'url' => $this->urlBuilder->getUrl('wtai/grid/savesettings')
        ];
    }
}
