<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Controller\Adminhtml\Settings;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use WriteTextAI\WriteTextAI\Model\ApiManager;
use Magento\Framework\App\Config\ConfigResource\ConfigInterface;
use WriteTextAI\WriteTextAI\Helper\Data;
use Magento\Framework\Module\ModuleListInterface;

class Popups extends Action
{
    public const MODULE_NAME = 'WriteTextAI_WriteTextAI';

    /**
     * @var ApiManager
     */
    protected $apiManager;

    /**
     * @var ConfigInterface
     */
    protected $configManager;

    /**
     * @var Data
     */
    protected $helper;

    /**
     * @var ModuleListInterface
     */
    protected $moduleList;

    /**
     * Constructor
     *
     * @param Context $context
     * @param ApiManager $apiManager
     * @param ConfigInterface $configManager
     * @param Data $helper
     * @param ModuleListInterface $moduleList
     */
    public function __construct(
        Context $context,
        ApiManager $apiManager,
        ConfigInterface $configManager,
        Data $helper,
        ModuleListInterface $moduleList
    ) {
        $this->apiManager = $apiManager;
        $this->configManager = $configManager;
        $this->helper = $helper;
        $this->moduleList = $moduleList;
        parent::__construct($context);
    }

    /**
     * Execute
     *
     * @return \Magento\Framework\Controller\Result\Json
     */
    public function execute()
    {
        $response = $this->resultFactory->create(ResultFactory::TYPE_JSON);

        try {
            $params = $this->getRequest()->getParams();

            switch ($params['type']) {
                case 'start_trial':
                    $this->apiManager->setUnlockedFreeTrialToFalse();
                    break;
                case 'no_more_trial_credits':
                    $this->apiManager->setNoCreditsFreeTrialToFalse();
                    break;
                case 'welcome_pro':
                    $this->apiManager->setUnlockedProfessionalToFalse();
                    break;
                case 'welcome_starter':
                    $this->apiManager->setWelcomePremium20ToFalse();
                    break;
                case 'welcome_enterprise':
                    $this->apiManager->setUnlockedEnterpriseToFalse();
                    break;
                case 'welcome_new_version':
                    $confPath = 'writetextai_settings/popups/welcome_new_version';
                    break;
            }

            if (isset($confPath)) {
                $this->configManager->saveConfig($confPath, $this->getModuleVersion(), 'default');
                $this->helper->flushConfigCache();
            }
            
            $result = [
                'success' => true
            ];
        } catch (\Exception $e) {
            $message = $e->getMessage();
            if (!$message) {
                $message = __(
                    'A system error has occurred. Please try again. If the issue persists,'
                    . ' please contact our support team at support@writetext.ai.'
                );
            }

            $result = [
                'success' => false,
                'message' => $message
            ];
        }

        $response->setData($result);

        return $response;
    }

    /**
     * Get module version
     *
     * @return string
     */
    protected function getModuleVersion()
    {
        return $this->moduleList->getOne(self::MODULE_NAME)['setup_version'];
    }
}
