<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Controller\Adminhtml\Grid\Transfer;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use WriteTextAI\WriteTextAI\Model\BulkTransferRequestsManager;
use WriteTextAI\WriteTextAI\Model\BulkGenerateRequestsManager;

class Progress extends Action
{
    /**
     * @var BulkTransferRequestsManager
     */
    protected $bulkTransferRequestsManager;

    /**
     * @var BulkGenerateRequestsManager
     */
    protected $BulkGenerateRequestsManager;

    /**
     * Constructor
     *
     * @param Context $context
     * @param BulkTransferRequestsManager $bulkTransferRequestsManager
     * @param BulkGenerateRequestsManager $BulkGenerateRequestsManager
     */
    public function __construct(
        Context $context,
        BulkTransferRequestsManager $bulkTransferRequestsManager,
        BulkGenerateRequestsManager $BulkGenerateRequestsManager
    ) {
        $this->bulkTransferRequestsManager = $bulkTransferRequestsManager;
        $this->BulkGenerateRequestsManager = $BulkGenerateRequestsManager;
        parent::__construct($context);
    }

    /**
     * Execute
     *
     * @return \Magento\Framework\Controller\Result\Json
     */
    public function execute()
    {
        $response = $this->resultFactory->create(ResultFactory::TYPE_JSON);
        try {
            $params = $this->getRequest()->getParams();
            if (isset($params['is_cancel']) && $params['is_cancel'] === 'true') {
                $this->bulkTransferRequestsManager->delete($params['user']);
            } else {
                $this->bulkTransferRequestsManager->saveBulkRequest(
                    $params['user'],
                    $params['stores'],
                    $params['store_id'],
                    $params['fields'],
                    $params['queue_ids'] ?? [],
                    $params['completed_ids'] ?? []
                );
                $this->BulkGenerateRequestsManager->deleteByUser($params['user']);
            }

            $result = [
                'success' => true
            ];
        } catch (\Exception $e) {
            $message = $e->getMessage();
            if (!$message) {
                $message = __(
                    'A system error has occurred. Please try again. If the issue persists,'
                    . ' please contact our support team at support@writetext.ai.'
                );
            }
            
            $result = [
                'success' => false,
                'message' => $message
            ];
        }

        $response->setData($result);

        return $response;
    }
}
