<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Controller\Adminhtml\Grid;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use WriteTextAI\WriteTextAI\Model\Api\CurlBuilder;

class Token extends Action
{
    /**
     * @var CurlBuilder
     */
    protected $curlBuilder;

    /**
     * Constructor
     *
     * @param Context $context
     * @param CurlBuilder $curlBuilder
     */
    public function __construct(
        Context $context,
        CurlBuilder $curlBuilder
    ) {
        $this->curlBuilder = $curlBuilder;
        parent::__construct($context);
    }

    /**
     * Execute
     *
     * @return \Magento\Framework\Controller\Result\Json
     */
    public function execute()
    {
        $response = $this->resultFactory->create(ResultFactory::TYPE_JSON);

        try {
            $renew = true;
            $result = [
                'success' => true,
                'access_token' => $this->curlBuilder->getUserWebToken($renew)
            ];
        } catch (\Exception $e) {
            $message = $e->getMessage();
            if (!$message) {
                $message = __(
                    'A system error has occurred. Please try again. If the issue persists,'
                    . ' please contact our support team at support@writetext.ai.'
                );
            }

            $result = [
                'success' => false,
                'message' => $message
            ];
        }

        $response->setData($result);

        return $response;
    }
}
