<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Controller\Adminhtml\Grid;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use WriteTextAI\WriteTextAI\Model\BulkGenerateRequestsManager;
use WriteTextAI\WriteTextAI\Model\BulkTransferRequestsManager;
use WriteTextAI\WriteTextAI\Model\BulkKeywordAnalysisRequestsManager;

class DismissMessage extends Action
{
    /**
     * @var BulkGenerateRequestsManager
     */
    protected $bulkGenerateRequestsManager;

    /**
     * @var BulkTransferRequestsManager
     */
    protected $bulkTransferRequestsManager;

    /**
     * @var BulkKeywordAnalysisRequestsManager
     */
    protected $bulkKeywordAnalysisRequestsManager;

    /**
     * Constructor
     *
     * @param Context $context
     * @param BulkGenerateRequestsManager $bulkGenerateRequestsManager
     * @param BulkTransferRequestsManager $bulkTransferRequestsManager
     * @param BulkKeywordAnalysisRequestsManager $bulkKeywordAnalysisRequestsManager
     */
    public function __construct(
        Context $context,
        BulkGenerateRequestsManager $bulkGenerateRequestsManager,
        BulkTransferRequestsManager $bulkTransferRequestsManager,
        BulkKeywordAnalysisRequestsManager $bulkKeywordAnalysisRequestsManager
    ) {
        $this->bulkGenerateRequestsManager = $bulkGenerateRequestsManager;
        $this->bulkTransferRequestsManager = $bulkTransferRequestsManager;
        $this->bulkKeywordAnalysisRequestsManager = $bulkKeywordAnalysisRequestsManager;
        parent::__construct($context);
    }

    /**
     * Execute
     *
     * @return \Magento\Framework\Controller\Result\Json
     */
    public function execute()
    {
        $response = $this->resultFactory->create(ResultFactory::TYPE_JSON);
        try {
            $requestId = $this->getRequest()->getParam('request_id');
            $transferUser = $this->getRequest()->getParam('transfer_user');
            $type = $this->getRequest()->getParam('type');

            switch ($type) {
                case 'keyword_analysis':
                    $this->bulkKeywordAnalysisRequestsManager->delete($requestId);
                    break;
                default:
                    if ($requestId) {
                        $this->bulkGenerateRequestsManager->delete($requestId);
                    } elseif ($transferUser) {
                        $this->bulkTransferRequestsManager->delete($transferUser);
                    } else {
                        $this->bulkGenerateRequestsManager->deleteAll();
                        $this->bulkTransferRequestsManager->deleteAll();
                        $this->bulkKeywordAnalysisRequestsManager->deleteAll();
                    }
                    break;
            }

            $result = [
                'success' => true
            ];
        } catch (\Exception $e) {
            $message = $e->getMessage();
            if (!$message) {
                $message = __(
                    'A system error has occurred. Please try again. If the issue persists,'
                    . ' please contact our support team at support@writetext.ai.'
                );
            }
            
            $result = [
                'success' => false,
                'message' => $message
            ];
        }

        $response->setData($result);

        return $response;
    }
}
