<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Controller\Adminhtml\Edit\Triggers;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use WriteTextAI\WriteTextAI\Model\Api\Keywords;

class Update extends Action
{
    /**
     * @var Keywords
     */
    protected $keywords;

    /**
     * Constructor
     *
     * @param Context $context
     * @param Keywords $keywords
     */
    public function __construct(
        Context $context,
        Keywords $keywords
    ) {
        $this->keywords = $keywords;
        parent::__construct($context);
    }

    /**
     * Execute action
     *
     * @return \Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        $result = $this->resultFactory->create(ResultFactory::TYPE_JSON);
        $pipelineIds = $this->getRequest()->getParam('pipeline_ids');

        try {
            if ($pipelineIds) {
                $apiResponse = $this->keywords->updatePipelineTriggerSettings(
                    $this->getRequest()->getParam('store_id'),
                    $this->getRequest()->getParam('record_id'),
                    $pipelineIds,
                    $this->getRequest()->getParam('difficulties'),
                    $this->getRequest()->getParam('option'),
                    $this->getRequest()->getParam('value'),
                    $this->getRequest()->getParam('action'),
                    $this->getRequest()->getParam('text_types'),
                    $this->getRequest()->getParam('entity_type'),
                );
            }
            $result->setData([
                'success' => true,
                'api_response' => $apiResponse ?? []
            ]);
        } catch (\Exception $e) {
            $message = $e->getMessage();
            if (!$message) {
                $message = __(
                    'A system error has occurred. Please try again. If the issue persists,'
                    . ' please contact our support team at support@writetext.ai.'
                );
            }
            
            $result->setData([
                'error' => $message,
                'trace' => $e->getTrace()
            ]);
        }

        return $result;
    }
}
