<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Controller\Adminhtml\Edit;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use WriteTextAI\WriteTextAI\Model\SingleGenerateRequestsManager;

class IsSingleRequest extends Action
{
    /**
     * @var SingleGenerateRequestsManager
     */
    protected $singleGenerateRequestsManager;

    /**
     * Constructor
     *
     * @param Context $context
     * @param SingleGenerateRequestsManager $singleGenerateRequestsManager
     */
    public function __construct(
        Context $context,
        SingleGenerateRequestsManager $singleGenerateRequestsManager
    ) {
        $this->singleGenerateRequestsManager = $singleGenerateRequestsManager;
        parent::__construct($context);
    }

    /**
     * Execute
     *
     * @return Json
     */
    public function execute()
    {
        $response = $this->resultFactory->create(ResultFactory::TYPE_JSON);

        $requestId = $this->getRequest()->getParam('request_id');
        $request = $this->singleGenerateRequestsManager->getSingleGenerateRequestsByRequestId($requestId);
        if ($request) {
            $response->setData(['is_single_request' => true]);
        } else {
            $response->setData(['is_single_request' => false]);
        }
        return $response;
    }
}
