<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Controller\Adminhtml\Categories\Edit;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use WriteTextAI\WriteTextAI\Model\AiCategoryManager;
use WriteTextAI\WriteTextAI\Model\Categories\GeneratedText;

class Save extends Action
{
    public const ADMIN_RESOURCE = 'WriteTextAI_WriteTextAI::edit';

    /**
     * @var AiCategoryManager
     */
    private $aiCategoryManager;

    /**
     * @var GeneratedText
     */
    private $generatedText;

    /**
     * Constructor
     *
     * @param Context $context
     * @param AiCategoryManager $aiCategoryManager
     * @param GeneratedText $generatedText
     */
    public function __construct(
        Context $context,
        AiCategoryManager $aiCategoryManager,
        GeneratedText $generatedText
    ) {
        $this->aiCategoryManager = $aiCategoryManager;
        $this->generatedText = $generatedText;
        parent::__construct($context);
    }

    /**
     * Execute
     *
     * @return \Magento\Framework\Controller\Result\Json
     */
    public function execute()
    {
        $response = $this->resultFactory->create(ResultFactory::TYPE_JSON);

        try {
            $params = $this->getRequest()->getParams();

            $this->generatedText->saveCategoryText(
                $params['store_id'],
                $params['category_id'],
                $params['selected_fields'],
                false,
                false
            );

            $this->aiCategoryManager->saveDate($params['category_id'], $params['store_id'], 'edited');

            $result = [
                'success' => true
            ];
        } catch (\Exception $e) {
            $message = $e->getMessage();
            if (!$message) {
                $message = __(
                    'A system error has occurred. Please try again. If the issue persists,'
                    . ' please contact our support team at support@writetext.ai.'
                );
            }

            $result = [
                'success' => false,
                'message' => $message
            ];
        }

        $response->setData($result);

        return $response;
    }
}
