<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Controller\Adminhtml\Categories\Edit;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use WriteTextAI\WriteTextAI\Model\Magento\Category as MagentoCategory;

class RepresentativeProducts extends Action
{
    /**
     * @var MagentoCategory
     */
    protected $magentoCategory;

    /**
     * Constructor
     *
     * @param Context $context
     * @param MagentoCategory $magentoCategory
     */
    public function __construct(
        Context $context,
        MagentoCategory $magentoCategory
    ) {
        $this->magentoCategory = $magentoCategory;
        parent::__construct($context);
    }

    /**
     * Execute
     *
     * @return \Magento\Framework\Controller\Result\Json
     */
    public function execute()
    {
        $response = $this->resultFactory->create(ResultFactory::TYPE_JSON);
        
        try {
            $categoryId = $this->getRequest()->getParam('category_id');
            $storeId = $this->getRequest()->getParam('store_id');
            $search = $this->getRequest()->getParam('search');
            $page = $this->getRequest()->getParam('page');

            $subcategories = $this->magentoCategory->getAllChildren(true, $categoryId, $storeId);
            $collection = $this->magentoCategory->getProductCollection(
                $subcategories,
                $storeId,
                $page,
                $search
            );
            
            $result = [
                'success' => true,
                'options' => $collection['options'],
                'total' => $collection['total']
            ];
        } catch (\Exception $e) {
            $message = $e->getMessage();
            if (!$message) {
                $message = __(
                    'A system error has occurred. Please try again. If the issue persists,'
                    . ' please contact our support team at support@writetext.ai.'
                );
            }

            $result = [
                'success' => false,
                'message' => $message
            ];
        }

        $response->setData($result);

        return $response;
    }
}
