<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Block\Adminhtml\Grid;

use Magento\Backend\Block\Template\Context;
use WriteTextAI\WriteTextAI\Model\Api\Session as ApiSession;
use WriteTextAI\WriteTextAI\Model\Api\CurlBuilder;
use WriteTextAI\WriteTextAI\Model\OptionSource\Filter\Fields;
use WriteTextAI\WriteTextAI\Helper\Data as Helper;
use WriteTextAI\WriteTextAI\Model\BulkGenerateRequestsManager;
use WriteTextAI\WriteTextAI\Model\BulkTransferRequestsManager;
use WriteTextAI\WriteTextAI\Model\BulkKeywordAnalysisRequestsManager;
use WriteTextAI\WriteTextAI\Model\BulkRequestsManager;
use WriteTextAI\WriteTextAI\Helper\CronStatus as CronStatusHelper;

class ProgressBar extends \Magento\Backend\Block\Template
{
    /**
     * @var ApiSession
     */
    protected $apiSession;

    /**
     * @var CurlBuilder
     */
    protected $curlBuilder;

    /**
     * @var Helper
     */
    protected $helper;

    /**
     * @var BulkGenerateRequestsManager
     */
    protected $bulkGenerateRequestsManager;

    /**
     * @var BulkTransferRequestsManager
     */
    protected $bulkTransferRequestsManager;

    /**
     * @var BulkKeywordAnalysisRequestsManager
     */
    protected $bulkKeywordAnalysisRequestsManager;

    /**
     * @var BulkRequestsManager
     */
    protected $bulkRequestsManager;

    /**
     * @var CronStatusHelper
     */
    protected $cronStatusHelper;

    /**
     * Constructor
     *
     * @param Context $context
     * @param ApiSession $apiSession
     * @param CurlBuilder $curlBuilder
     * @param Helper $helper
     * @param BulkGenerateRequestsManager $bulkGenerateRequestsManager
     * @param BulkTransferRequestsManager $bulkTransferRequestsManager
     * @param BulkKeywordAnalysisRequestsManager $bulkKeywordAnalysisRequestsManager
     * @param BulkRequestsManager $bulkRequestsManager
     * @param CronStatusHelper $cronStatusHelper
     * @param array $data
     */
    public function __construct(
        Context $context,
        ApiSession $apiSession,
        CurlBuilder $curlBuilder,
        Helper $helper,
        BulkGenerateRequestsManager $bulkGenerateRequestsManager,
        BulkTransferRequestsManager $bulkTransferRequestsManager,
        BulkKeywordAnalysisRequestsManager $bulkKeywordAnalysisRequestsManager,
        BulkRequestsManager $bulkRequestsManager,
        CronStatusHelper $cronStatusHelper,
        array $data = []
    ) {
        $this->apiSession = $apiSession;
        $this->curlBuilder = $curlBuilder;
        $this->helper = $helper;
        $this->bulkGenerateRequestsManager = $bulkGenerateRequestsManager;
        $this->bulkTransferRequestsManager = $bulkTransferRequestsManager;
        $this->bulkKeywordAnalysisRequestsManager = $bulkKeywordAnalysisRequestsManager;
        $this->bulkRequestsManager = $bulkRequestsManager;
        $this->cronStatusHelper = $cronStatusHelper;
        parent::__construct($context, $data);
    }

    /**
     * Get current user
     *
     * @return \Magento\User\Model\User
     */
    public function getUser()
    {
        $user = $this->apiSession->getCurrentUser();

        $userData = [
            'id' => '',
            'name' => '',
            'email' => '',
        ];

        if ($user) {
            $userData['id'] = $user->getId();
            $userData['name'] = $user->getFirstName() . ' ' . $user->getLastName();
            $userData['email'] = $user->getEmail();
        }

        return $userData;
    }

    /**
     * Get generate statuses
     *
     * @return array
     */
    public function getStatuses()
    {
        $bulkRequests = $this->bulkRequestsManager->getBulkRequests();
        return $bulkRequests;
        // $generateStatuses = $this->bulkGenerateRequestsManager->getBulkRequests();
        // $keywordAnalysisStatus = $this->bulkKeywordAnalysisRequestsManager->getBulkRequest();

        // return array_merge($generateStatuses, $keywordAnalysisStatus);
    }

    /**
     * Get transfer statuses
     *
     * @return array
     */
    public function getTransferStatuses()
    {
        return $this->bulkTransferRequestsManager->getBulkRequests();
    }

    /**
     * Get access token
     *
     * @return string
     */
    public function getAccessToken()
    {
        return $this->curlBuilder->getUserWebToken();
    }

    /**
     * Get signalr url
     *
     * @return string
     */
    public function getSignalrUrl()
    {
        return $this->helper->getSignalrUrl();
    }

    /**
     * Get meta title
     *
     * @return string
     */
    public function getPageTitle()
    {
        return Fields::PAGE_TITLE;
    }

    /**
     * Get meta description
     *
     * @return string
     */
    public function getPageDescription()
    {
        return Fields::PAGE_DESCRIPTION;
    }

    /**
     * Get description
     *
     * @return string
     */
    public function getProductDescription()
    {
        return Fields::PRODUCT_DESCRIPTION;
    }

    /**
     * Get excerpt
     *
     * @return string
     */
    public function getExcerpt()
    {
        return Fields::EXCERPT;
    }

    /**
     * Get open graph
     *
     * @return string
     */
    public function getOpenGraph()
    {
        return Fields::OPEN_GRAPH;
    }

    /**
     * Get meta title
     *
     * @return string
     */
    public function getCategoryPageTitle()
    {
        return Fields::CATEGORY_PAGE_TITLE;
    }

    /**
     * Get meta description
     *
     * @return string
     */
    public function getCategoryPageDescription()
    {
        return Fields::CATEGORY_PAGE_DESCRIPTION;
    }

    /**
     * Get description
     *
     * @return string
     */
    public function getCategoryDescription()
    {
        return Fields::CATEGORY_DESCRIPTION;
    }

    public function isCronRunning()
    {
        return $this->cronStatusHelper->isCronRunning();
    }
}
