<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Api;

use Magento\Framework\Api\SearchCriteriaInterface;

interface SettingRepositoryInterface
{
    /**
     * Save Setting
     *
     * @param \WriteTextAI\WriteTextAI\Api\Data\SettingInterface $setting
     * @return \WriteTextAI\WriteTextAI\Api\Data\SettingInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function save(
        \WriteTextAI\WriteTextAI\Api\Data\SettingInterface $setting
    );

    /**
     * Retrieve Setting
     *
     * @param string $settingId
     * @return \WriteTextAI\WriteTextAI\Api\Data\SettingInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function get($settingId);

    /**
     * Retrieve Setting matching the specified criteria.
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     * @return \WriteTextAI\WriteTextAI\Api\Data\SettingSearchResultsInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function getList(
        \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
    );

    /**
     * Delete Setting
     *
     * @param \WriteTextAI\WriteTextAI\Api\Data\SettingInterface $setting
     * @return bool true on success
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function delete(
        \WriteTextAI\WriteTextAI\Api\Data\SettingInterface $setting
    );

    /**
     * Delete Setting by ID
     *
     * @param string $settingId
     * @return bool true on success
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function deleteById($settingId);
}
