<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Api;

use Magento\Framework\Api\SearchCriteriaInterface;

interface NewRecordsRepositoryInterface
{

    /**
     * Save New_records
     *
     * @param \WriteTextAI\WriteTextAI\Api\Data\NewRecordsInterface $newRecords
     * @return \WriteTextAI\WriteTextAI\Api\Data\NewRecordsInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function save(
        \WriteTextAI\WriteTextAI\Api\Data\NewRecordsInterface $newRecords
    );

    /**
     * Retrieve New_records
     *
     * @param string $id
     * @return \WriteTextAI\WriteTextAI\Api\Data\NewRecordsInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function get($id);

    /**
     * Retrieve New_records matching the specified criteria.
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     * @return \WriteTextAI\WriteTextAI\Api\Data\NewRecordsSearchResultsInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function getList(
        \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
    );

    /**
     * Delete New_records
     *
     * @param \WriteTextAI\WriteTextAI\Api\Data\NewRecordsInterface $newRecords
     * @return bool true on success
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function delete(
        \WriteTextAI\WriteTextAI\Api\Data\NewRecordsInterface $newRecords
    );

    /**
     * Delete New_records by ID
     *
     * @param string $id
     * @return bool true on success
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function deleteById($id);
}
