<?php
declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Api;

/**
 * Interface ImageBase64ApiInterface
 * API endpoint for retrieving image data in base64 format
 */
interface ImageBase64ApiInterface
{
    /**
     * Get image data in base64 format
     *
     * @param string $imageId
     * @return \Magento\Framework\DataObject
     */
    public function getBase64(string $imageId);
}
