<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Api\Data;

interface BulkTransferRequestsInterface
{

    public const QUEUE_IDS = 'queue_ids';

    public const BULK_TRANSFER_REQUESTS_ID = 'id';

    public const USER = 'user';

    public const COMPLETED_IDS = 'completed_ids';

    public const SUCCESS_IDS = 'success_ids';

    public const STORES_SELECTED = 'stores_selected';

    public const STORE_FILTER = 'store_filter';

    public const FIELDS_SELECTED = 'fields_selected';

    public const IS_CANCELLED = 'is_cancelled';

    public const TRANSFERRED_AT = 'transferred_at';

    public const ERROR_IDS = 'error_ids';

    public const SKIPPED_IDS = 'skipped_ids';

    public const STARTED_AT = 'started_at';

    /**
     * Get bulk_transfer_requests_id
     *
     * @return string|null
     */
    public function getBulkTransferRequestsId();

    /**
     * Set bulk_transfer_requests_id
     *
     * @param string $bulkTransferRequestsId
     * @return \WriteTextAI\WriteTextAI\BulkTransferRequests\Api\Data\BulkTransferRequestsInterface
     */
    public function setBulkTransferRequestsId($bulkTransferRequestsId);

    /**
     * Get user
     *
     * @return string|null
     */
    public function getUser();

    /**
     * Set user
     *
     * @param string $user
     * @return \WriteTextAI\WriteTextAI\BulkTransferRequests\Api\Data\BulkTransferRequestsInterface
     */
    public function setUser($user);

    /**
     * Get queue_ids
     *
     * @return string|null
     */
    public function getQueueIds();

    /**
     * Set queue_ids
     *
     * @param string $queueIds
     * @return \WriteTextAI\WriteTextAI\BulkTransferRequests\Api\Data\BulkTransferRequestsInterface
     */
    public function setQueueIds($queueIds);

    /**
     * Get completed_ids
     *
     * @return string|null
     */
    public function getCompletedIds();

    /**
     * Set completed_ids
     *
     * @param string $completedIds
     * @return \WriteTextAI\WriteTextAI\BulkTransferRequests\Api\Data\BulkTransferRequestsInterface
     */
    public function setCompletedIds($completedIds);

    /**
     * Get success_ids
     *
     * @return string|null
     */
    public function getSuccessIds();

    /**
     * Set success_ids
     *
     * @param string $successIds
     * @return \WriteTextAI\WriteTextAI\BulkTransferRequests\Api\Data\BulkTransferRequestsInterface
     */
    public function setSuccessIds($successIds);

    /**
     * Get stores_selected
     *
     * @return string|null
     */
    public function getStoresSelected();

    /**
     * Set stores_selected
     *
     * @param string $storesSelected
     * @return \WriteTextAI\WriteTextAI\BulkTransferRequests\Api\Data\BulkTransferRequestsInterface
     */
    public function setStoresSelected($storesSelected);

    /**
     * Get store_filter
     *
     * @return string|null
     */
    public function getStoreFilter();

    /**
     * Set store_filter
     *
     * @param string $storeFilter
     * @return \WriteTextAI\WriteTextAI\BulkTransferRequests\Api\Data\BulkTransferRequestsInterface
     */
    public function setStoreFilter($storeFilter);

    /**
     * Get fields_selected
     *
     * @return string|null
     */
    public function getFieldsSelected();

    /**
     * Set fields_selected
     *
     * @param string $fieldsSelected
     * @return \WriteTextAI\WriteTextAI\BulkTransferRequests\Api\Data\BulkTransferRequestsInterface
     */
    public function setFieldsSelected($fieldsSelected);

    /**
     * Get is_cancelled
     *
     * @return int|null
     */
    public function getIsCancelled();

    /**
     * Set is_cancelled
     *
     * @param int $isCancelled
     * @return \WriteTextAI\WriteTextAI\BulkTransferRequests\Api\Data\BulkTransferRequestsInterface
     */
    public function setIsCancelled($isCancelled);

    /**
     * Get transferred_at
     *
     * @return string|null
     */
    public function getTransferredAt();

    /**
     * Set transferred_at
     *
     * @param string $transferredAt
     * @return \WriteTextAI\WriteTextAI\BulkTransferRequests\Api\Data\BulkTransferRequestsInterface
     */
    public function setTransferredAt($transferredAt);

    /**
     * Get error_ids
     *
     * @return string|null
     */
    public function getErrorIds();

    /**
     * Set error_ids
     *
     * @param string $errorIds
     * @return \WriteTextAI\WriteTextAI\BulkTransferRequests\Api\Data\BulkTransferRequestsInterface
     */
    public function setErrorIds($errorIds);

    /**
     * Get skipped_ids
     *
     * @return string|null
     */
    public function getSkippedIds();

    /**
     * Set skipped_ids
     *
     * @param string $skippedIds
     * @return \WriteTextAI\WriteTextAI\BulkTransferRequests\Api\Data\BulkTransferRequestsInterface
     */
    public function setSkippedIds($skippedIds);

    /**
     * Get started_at
     *
     * @return string|null
     */
    public function getStartedAt();

    /**
     * Set started_at
     *
     * @param string $startedAt
     * @return \WriteTextAI\WriteTextAI\BulkTransferRequests\Api\Data\BulkTransferRequestsInterface
     */
    public function setStartedAt($startedAt);
}
